#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2007 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

require 'aprs4r/Plugin'
require 'aprs4r/SamplePluginConfiguration'


module APRS4R

  class SamplePlugin < Plugin

    @logger = APRS4RLogger.get_logger( "SamplePlugin")

    
    def initialize( configuration)
      logger.info( "initialize( configuration)")

      super( configuration)

      # save configuration variables here

      return
    end

    
    def registerListener
      logger.info( "registerListener")

      if @enable
        # register on a device (device as parameter)
        # SocketManager.addListener( "rf0", self)
      end

      return
    end


    def unregisterListener
      logger.info( "registerListener")

      if @enable
        # unregister
        # SocketManager.removeListener( "rf0", self)
      end

      return
    end


    def start
      logger.info( "start")

      if ! @enable
        return
      end

      registerListener

      return
    end

    
    def receiveAPRSMessage( name, message)
      logger.info( "receiveAPRSMessage( name, message)")

      if message.nil?
        logger.warn( "message: nil")
        return
      end
    
    end

  end

end
