#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2008 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

require 'aprs4r/WeatherPlugin'


module APRS4R

  class DummyWeatherPlugin < WeatherPlugin

    @logger = APRS4RLogger.get_logger( "DummyWeatherPlugin")

    
    def initialize( configuration)
      logger.info( "initialize( configuration)")

      super( configuration)
      
      # mandatory parameters
      @wind_direction = 180
      @wind_avg = 1.234
      @wind_gust = 5.678

      @temperature = 23.4

      # optional parameters
      @rain_1h = 0.0254
      @rain_24h = 0.0508
      @rain_day = 0.0508

      @rain_1h = @rain_24h = @rain_day = nil

      @humidity = 34
      @pressure = 1005
      @luminosity = 800
      
      return
    end


    def start
      logger.info( "start")

      return
    end

  end

end
