#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2008 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

require 'aprs4r/APRSCall'
require 'aprs4r/APRSMessage'

require 'aprs4r/Plugin'
require 'aprs4r/BeaconPlugin'
require 'aprs4r/WeatherPlugin'
require 'aprs4r/WeatherBeaconPluginConfiguration'
require 'aprs4r/SocketManager'
require 'aprs4r/PluginManager'


module APRS4R

  class WeatherBeaconPlugin < BeaconPlugin

    @logger = APRS4RLogger.get_logger( "WeatherBeaconPlugin")


    def initialize( configuration)
      logger.info( "initialize( configuration)")

      super( configuration)

      return
    end


    def create_beacon
      logger.info( "create_beacon")
      
      weather_plugin = PluginManager.get_plugin( WeatherPlugin)

      weather_message = @message.clone

      # build aprs weather message
      if weather_plugin
        weather_payload = String.new
        
        # wind data
        # degree
        wind_direction = weather_plugin.wind_direction 
        payload = "c..."
        payload = sprintf( "c%3.3i", wind_direction) if wind_direction
        weather_payload += payload
        
        # mph
        wind_avg = WeatherPlugin.mps_to_mph( weather_plugin.wind_avg)
        payload = "s..."
        payload = sprintf( "c%3.3i", wind_avg) if wind_avg
        weather_payload += payload 
        
        wind_gust = WeatherPlugin.mps_to_mph( weather_plugin.wind_gust)
        payload = "g..."
        payload = sprintf( "g%3.3i", wind_gust) if wind_gust
        weather_payload += payload 

        # temperature 
        # fahrenheit
        temperature = WeatherPlugin.celcius_to_fahrenheit( weather_plugin.temperature)
        payload = "t..."
        payload = sprintf( "t%3.3i", temperature) if temperature
        weather_payload += payload

        # rain
        # hundreths of an inch
        rain_1h = WeatherPlugin.meter_to_inch( weather_plugin.rain_1h)
        weather_payload += sprintf( "r%3.3i", rain_1h * 100.0) if rain_1h

        rain_24h = WeatherPlugin.meter_to_inch( weather_plugin.rain_24h)
        weather_payload += sprintf( "p%3.3i", rain_24h * 100.0) if rain_24h

        rain_day = WeatherPlugin.meter_to_inch( weather_plugin.rain_day)
        weather_payload += sprintf( "P%3.3i", rain_day * 100.0) if rain_day

        # humidity 
        # percent
        humidity = weather_plugin.humidity
        weather_payload += sprintf( "h%2.2i", humidity) if humidity

        # pressure 
        # tenths of millibars/tenths of hPascal
        pressure = weather_plugin.pressure
        weather_payload += sprintf( "b%5.5i", pressure * 10.0) if pressure
        
        logger.debug( "weather_payload: #{weather_payload}")
        # weather_message.payload += weather_payload
      end

      return weather_message
    end

  end

end
