#!/usr/bin/ruby
#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2007 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'test/unit'

log4r_file = ENV['APRS4R_LOG4R'] || "#{default_path}/log4r.yaml"

print "log4r_file: #{log4r_file}\n"

require 'aprs4r/APRS4RLogger'
include APRS4R

APRS4RLogger::load_yaml_file( log4r_file)

require 'aprs4r/APRSMessage'
require 'aprs4r/MICEMessage'


module APRS4R
  class MICEMessageTest < Test::Unit::TestCase
    
    def setup
      @mice_message = APRSMessage.new( "FROM", "S32UVT", [], "`(_fn\"Oj/This is the mic-e status")
      @unknown_message = APRSMessage.new( "FROM", "TO", [], ">This is not an mice message")
    end
    
    
    def test_not_mice
      assert( !@unknown_message.is_mice?)
    end
    
    
    def test_mice
      assert( @mice_message.is_mice?)
    end
    
    
    def test_course
      assert_equal( 251, MICEMessage.course_direction( @mice_message))
      assert_equal( 20, MICEMessage.course_speed( @mice_message))
    end
    
    
    def test_latitude
      assert_in_delta( 33.4273, MICEMessage.latitude( @mice_message), 0.001)
    end
    
    
    def test_longitude
      assert_in_delta( -112.129, MICEMessage.longitude( @mice_message), 0.001)    
    end
    
    def test_status
      assert_equal( "This is the mic-e status", @mice_message.status)
    end
    
    
    def test_mice_position
      message = APRSMessage.new( "ON4CBZ-9", "UQ0WR0", [], "`zXQl Iv/]\"4F}QRV ON REPEATER OF OOSTENDE")
      
      assert( message.is_mice?)
      assert( message.has_position?)
      
      print "latitude: #{message.latitude}\n"
      print "longitude: #{message.longitude}\n"
      
      print "direction: #{message.course_direction}\n"
      print "speed: #{message.course_speed}\n"
    end
    
    
    def test_mice_course
      moving = APRSMessage.new( "MYCALL-9", "UQ1PV6", [], "`|(Gn\<>/]\"9N}")
      not_moving = APRSMessage.new( "MYCALL-9", "UQ0WR0", [], "`zXQl Iv/]\"4F}QRV ON REPEATER OF OOSTENDE")
      
      print "direction1: #{moving.course_direction}\n"
      print "direction2: #{not_moving.course_direction}\n"
      
      print "speed1: #{moving.course_speed}\n"
      print "speed2: #{not_moving.course_speed}\n"
    end
    
    
    def test_mice_example
      message = APRSMessage.new( "MYCALL", "UNKNOWN", [], "`(_fn\"Oj/")
      
      print "test_mice_example\n"
      
      print "direction: #{message.course_direction}\n"
      print "speed: #{message.course_speed}\n"
    end
    
  end

end
  
