#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

require 'aprs4r/APRSMessage'
require 'aprs4r/WeatherPlugin'
require 'aprs4r/WS2300WeatherPluginConfiguration'


module APRS4R

  class WS2300WeatherPlugin < WeatherPlugin

    @logger = APRS4RLogger.get_logger( "WS2300WeatherPlugin")


    @@WIND_DIRECTION_INVALID = "0.0"
    @@WIND_SPEED_INVALID = "51.0"

    @@TEMPERATURE_INVALID = "81.1"

    @@HUMIDITY_INVALID = "110"

    
    def initialize( configuration)
      logger.info( "initialize( configuration)")

      super( configuration)

      @file = configuration.file

      return
    end

    def createWeatherAPRSMessage
      logger.info( "createWeatherAPRSMessage")

      # TODO: recover from file error

      # read in last line of file
      file = File.open( @file, "r")

      data = nil
      while line = file.gets
        data = line.chomp! if line
      end

      file.close

      logger.debug( "data: #{data}")

      # build up aprs weather message 
      message = nil

      if data
        # copy default message
        message = @message.clone
        weather = String.new

        values = data.split( / /)

        # write wind data
        wind_direction = "..."
        wind_direction = sprintf( "%3.3i", values[9].to_i) if values[9] && values[9] != @@WIND_DIRECTION_INVALID
        
        wind_avg_speed = "..."
        wind_avg_speed = sprintf( "%3.3i", values[8].to_i) if values[8] && values[8] != @@WIND_SPEED_INVALID
        
        wind_gust_speed = "g..."
        # no gust speed
        # wind_gust_speed = sprintf( "g%3.3i", @wind_gust_speed) if @wind_gust_speed
        
        # temperature
        temperature = "t..."
        temperature = sprintf( "t%3.3i", values[4].to_i) if values[4] && values[4] != @@TEMPERATURE_INVALID
        
        # rain
        rain_current = "r..."
        rain_current = sprintf( "r%3.3i", values[12].to_i) if values[12]
        
        rain_24h = "p..."
        rain_24h = sprintf( "p%3.3i", values[13].to_i) if values[13]
        
        rain_yesterday = "R..."
        # no rain yesterday
        # rain_yesterday = sprintf( "R%3.3i", @rain_total) if @rain_yesterday
        
        # humidity/pressure
        humidity = "h.."
        humidity = sprintf( "h%2.2i", values[7].to_i) if values[7] && values[7] != @@HUMIDITY_INVALID
        
        pressure = "b....."
        pressure = sprintf( "b%5.5i", (values[15].to_f * 10.0).to_i) if values[15]
        
        weather += wind_direction + "/" + wind_avg_speed + wind_gust_speed
        weather += temperature + rain_current + rain_24h + rain_yesterday
        weather += humidity + pressure

        logger.debug( "weather: #{weather}")
        
        message.payload += weather
        logger.debug( "message: #{message.to_s}")
        
      end

      # return message
      return nil
    end

  end

end
