#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRS4RLogger'

require 'aprs4r/BeaconPlugin'
require 'aprs4r/APRSCall'
require 'aprs4r/ProportionalBeaconPluginConfiguration'
require 'aprs4r/SocketManager'


module APRS4R

  class ProportionalBeaconPlugin < BeaconPlugin

    @logger = APRS4RLogger.get_logger( "ProportionalBeaconPlugin")


    def initialize( configuration)
      logger.info( "initialize( configuration)")

      super( configuration)

      @hops = 2

      begin
        @hops = configuration.hops.to_i if configuration.hops
      rescue Exception => ex 
        logger.error( "Error reading variable hops: #{configuration.hops}")
      end

      @hops = 7 if @hops > 7

      @mode = "wide"
      
      begin 
        @mode = configuration.mode if configuration.mode
      rescue Exception => ex 
        logger.error( "Error reading variable mode: #{configuration.mode}")
      end

      return
    end


    def start
      logger.info( "start")

      if ! @enable 
        return
      end

      Thread.new { run } 

      return
    end

    
    def run
      logger.info( "run")

      Thread.abort_on_exception = true

      sleep @offset

      time = 0 
      near_interval = 0 
      wide_interval = 0 

      while true

        current_hops = 0 

        if near_interval >= (15 * 60)
          near_interval = 0 
          current_hops = @hops / 2
        end

        if wide_interval >= (30 * 60)
          near_interval = 0 
          wide_interval = 0 
          current_hops = @hops 
        end

        
        # build new path
        new_path = Array.new

        if @mode == "fillin"
          if current_hops >= 1 
            new_path << "WIDE1-1"
          end

          if current_hops >= 2
            new_path << "WIDE#{current_hops}-#{current_hops-1}"
          end
        else
          if current_hops == 1 
            new_path << "WIDE2-1" 
          elsif current_hops > 1
            new_path << "WIDE#{current_hops}-#{current_hops}"
          end
        end
        

        @message.path = new_path
        
        logger.debug( "sending beacon #{@message} on device #{@device}")
        SocketManager.sendAPRSMessage( @device, @message)

        sleep @period

        near_interval += @period
        wide_interval += @period
      end
      
      return
    end

  end

end
