#!/usr/bin/ruby
#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#


module APRS4R
  APRS4RVersion = [0, 9, 9, 1].join( '.')

  APRS4RCall = "AP4R09"
end

# require 'memory_profiler'
# 
# MemoryProfiler.start( {:string_debug => true})

# FIXME: not necessary, if patched log4r is available
# require 'log4r/outputter/serialoutputter'

module APRS4R

  # we want to see stacktraces from all threads
  Thread.abort_on_exception = true


  # load log4r 
  require 'aprs4r/APRS4RLogger'
  
  begin
    log4r_name = ENV['APRS4R_LOG4R'] || "/etc/aprs4r/aprs4r.log4r"
    APRS4RLogger.load_yaml_file( log4r_name)
  rescue Exception => ex
    printf( $stderr, "Error loading log4r configuration: #{log4r_name}, ex: #{ex}\n")
    exit 8
  end


  # write pid file 
  begin
    pid_name = ENV['APRS4R_PID'] || "/var/run/aprs4r.pid"
    
    pid_file = File.new( pid_name, "w")
    pid_file.puts( Process.pid)
    pid_file.close
  rescue Exception => ex
    printf( $stderr, "Error writing pid file: #{pid_name}\n")
    exit 4
  end
    

  # load configuration
  require 'aprs4r/APRS4RConfiguration'

  configuration = nil

  begin 
    aprs4r_name = ARGV[0] 
  
    configuration = APRS4RConfiguration.loadConfiguration( aprs4r_name)
  rescue Exception => ex
    printf( $stderr, "Error loading aprs4r configuration: #{aprs4r_name}\n")
    exit 2
  end
  

  # start software
  require 'aprs4r/SocketManager'
  require 'aprs4r/PluginManager'
  

  # init socket manager
  SocketManager.init( configuration)
  
  sleep 2
  
  # start plugin manager
  PluginManager.init( configuration)
  PluginManager.start()
  
  sleep

end

