#!/usr/bin/ruby
#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'tests/include'
require 'test/unit'

log4r_file = ENV['APRS4R_LOG4R'] || "/etc/aprs4r/default.log4r"

print "log4r_file: #{log4r_file}\n"

require 'Logger'
require 'Log4rConfigurator'

Log4rConfigurator::configure_from_yaml_file( log4r_file)

require 'aprs4r/APRSMessage'
require 'aprs4r/DigipeaterPlugin'
require 'aprs4r/DigipeaterPluginConfiguration'


class FillinDigipeaterPluginTest < Test::Unit::TestCase

  
  def setup
    configuration = DigipeaterPluginConfiguration.new

    configuration.device = "test0"
    configuration.call = "DO5MC"
    configuration.mode = "fillin"
    configuration.aliases = [ "DO5MC"]
    configuration.hops = 2

    @plugin = DigipeaterPlugin.new( configuration)
  end
  

  def test_do_digipeating_simple_wide2
    message = APRSMessage.new
    message.source = "DO5MC"
    message.destination = "AP4R00"
    message.path = [ "DL1LJ*", "WIDE2-1"]
    message.payload = ""

    print "message: #{message}\n"

    result = @plugin.do_digipeating( "test0", message)
    
    assert_nil( result)

    return
  end


  def test_do_digipeating_simple_wide3
    message = APRSMessage.new
    message.source = "DO5MC"
    message.destination = "AP4R00"
    message.path = [ "DL1LJ*", "WIDE3-1"]
    message.payload = ""
    
    print "message: #{message}\n"
    
    result = @plugin.do_digipeating( "test0", message)
    
    assert_nil( result)
    
    return
  end

end
  
