#!/usr/bin/ruby
#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'test/unit'

log4r_file = ENV['APRS4R_LOG4R'] || "#{default_path}/log4r.yaml"

print "log4r_file: #{log4r_file}\n"

require 'Logger'
require 'Log4rConfigurator'

Log4rConfigurator::configure_from_yaml_file( log4r_file)

require 'aprs4r/APRSMessage'


class APRSMessageTest < Test::Unit::TestCase


  def test_degree2decimal_zero
    position1 = "0000.00N"
    assert_equal( 0.0, APRSMessage.degree2decimal( position1))

    position2 = "0000.00S"
    assert_equal( 0.0, APRSMessage.degree2decimal( position2))

    position3 = "00000.00E"
    assert_equal( 0.0, APRSMessage.degree2decimal( position3))

    position4 = "00000.00W"
    assert_equal( 0.0, APRSMessage.degree2decimal( position4))
  end

  
  def test_degree2decimal_north
    position = "4900.00N"
    assert_in_delta( 49.0, APRSMessage.degree2decimal( position), 0.0001)
    assert_not_equal( -49.0, APRSMessage.degree2decimal( position))
  end

  def test_degree2decimal_south
    position = "4930.00S"
    assert_in_delta( -49.50, APRSMessage.degree2decimal( position), 0.0001)
  end

  def test_degree2decimal_second1
    position = "4930.50N"
    assert_in_delta( 49.5083, APRSMessage.degree2decimal( position), 0.0001)
  end

  
  def test_degree2decimal_east
    position = "00800.00E"
    assert_in_delta( 8.0, APRSMessage.degree2decimal( position), 0.0001)
    assert_not_equal( -8.0, APRSMessage.degree2decimal( position), 0.0001)
  end

  def test_degree2decimal_west
    position = "11245.00W"
    assert_in_delta( -112.75, APRSMessage.degree2decimal( position), 0.0001)
  end

  def test_degree2decimal_second2
    position = "9423.69N"
    assert_in_delta( 94.3948, APRSMessage.degree2decimal( position), 0.0001)
  end

  

end
  
