#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'Logger'

require 'aprs4r/APRSMessage'
require 'aprs4r/Plugin'
require 'aprs4r/WeatherConfiguration'


class WeatherPlugin < Plugin

  @@logger = Logger.get_logger( "WeatherPlugin")

  
  def initialize( configuration)
    @@logger.info( "initialize( configuration)")

    super( configuration)

    @device = configuration.device
    @period = configuration.period
    @offset = configuration.offset

    # template aprs message
    @message = configuration.message

    return
  end
  
  
  def start 
    @@logger.info( "start")

    if ! @enable
      return
    end

    Thread.new{ run }

    return
  end


  def run
    @@logger.info( "run")

    sleep @offset

    while true

      message = createWeatherAPRSMessage

      if message
        @@logger.debug( "sending weather aprs message: #{message.to_s}")
        SocketManager.sendAPRSMessage( @device, message)
      end

      sleep @period
    end

    return
  end


  def createWeatherAPRSMessage
    @@logger.info( "createWeatherAPRSMessage")

    @@logger.warn( "abstract class method")

    return nil
  end
  
end
