#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'Logger'

require 'aprs4r/APRSMessage'
require 'aprs4r/WeatherPlugin'
require 'aprs4r/WS2300WeatherConfiguration'


class WS2300WeatherPlugin < WeatherPlugin

  @@logger = Logger.get_logger( "WS2300WeatherPlugin")

  
  def initialize( configuration)
    @@logger.info( "initialize( configuration)")

    super( configuration)

    @file = configuration.file

    return
  end

  def createWeatherAPRSMessage
    @@logger.info( "createWeatherAPRSMessage")


    # read in last line of file
    file = File.open( @file, "r")
    @@logger.debug( "file: #{file}")

    data = nil
    while line = file.gets
      data = line.chomp! if line
    end

    file.close


    # build up aprs weather message 
    @@logger.debug( "data: #{data}")
    
    # copy default message
    message = @message.clone

    payload = ":" + data

    message.payload = payload

    return message
  end
end
