#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/ConfigurationAttribute'


class SocketConfiguration

  attr_reader :name, :type, :enable, :duplicatePeriod
  attr_writer :name, :type, :enable, :duplicatePeriod


  def to_yaml_properties
    return %w{@name @type @enable @duplicatePeriod}
  end


  def attributes

    attributes = [ 
                  ConfigurationAttribute.new( "name", true, 01, "text", "Name", 10), 
                  ConfigurationAttribute.new( "type", false, 02, "text", "Typ", 10),
                  ConfigurationAttribute.new( "enable", true, 03, "boolean", "aktiviert", 0),
                  ConfigurationAttribute.new( "duplicatePeriod", true, 04, "int", "Duplikat", 10)
                 ]

    return attributes
  end

  def SocketConfiguration.subclasses
    return [ "AX25Socket", "ISSocket"]
  end

end
