#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRSCall'

class PluginConfiguration

  attr_reader :name, :type, :enable
  attr_writer :name, :type, :enable


  def to_yaml_properties
    return %w{ @name @type @enable}
  end


  def attributes

    pluginSelection = [ "BeaconPlugin"]
    attributes = [ 
                  ConfigurationAttribute.new( "name", 01, "text", "Name", 10), 
                  ConfigurationAttribute.new( "type", 02, "select", "Typ", 10, pluginSelection),
                  ConfigurationAttribute.new( "enable", 03, "boolean", "aktiviert", 0),
                 ]

    return attributes
  end

end
