#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/SocketConfiguration'
require 'aprs4r/ConfigurationAttribute'


class ISSocketConfiguration < SocketConfiguration

  attr_reader :hosts, :port, :username, :filter, :timeout
  attr_writer :hosts, :port, :username, :filter, :timeout


  def to_yaml_properties
    super + %w{@hosts @port @username @filter @timeout}
  end


  def attributes
    attributes = [
                  ConfigurationAttribute.new( "host", true, 10, "string", "Hostname", 10),
                  ConfigurationAttribute.new( "port", true, 11, "int", "Portnummer", 6),
                  ConfigurationAttribute.new( "username", true, 12, "string", "Benutzer", 10),
                  ConfigurationAttribute.new( "filter", true, 13, "string", "Filter", 20),
                  ConfigurationAttribute.new( "timeout", true, 15, "int", "Timeout", 6)
                 ]

    return super + attributes 
  end

end
