#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/ConfigurationAttribute'
require 'aprs4r/PluginConfiguration'

require 'aprs4r/APRSCall'
require 'aprs4r/APRSMessage'


class BeaconPluginConfiguration < PluginConfiguration

  attr_reader :device, :period, :offset, :message
  attr_writer :device, :period, :offset, :message


  def to_yaml_properties
    return super + %w{ @device @period @offset @message}
  end

  
  def attributes
    
    attributes = [ 
                  ConfigurationAttribute.new( "device", 11, "text", "Name", 10), 
                  ConfigurationAttribute.new( "period", 12, "int", "Periode", 10),
                  ConfigurationAttribute.new( "offset", 13, "int", "Offset", 0),
                  ConfigurationAttribute.new( "message", 14, "complex", "Bake", 10, APRSMessage.attributes)
                 ]

    return super + attributes
  end

end
