#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'Logger'


class APRSCall

  include Comparable

  attr_reader :call, :ssid, :repeated
  attr_writer :call, :ssid, :repeated

  @@logger = Logger.get_logger( "APRSCall")


  def initialize( call = "", ssid = 0, repeated = false)
    @@logger.info( "initialize( call, ssid, repeated)")

    @call = call
    @ssid = ssid
    @repeated = repeated

    return
  end


  def clone
    @@logger.info( "clone")

    return APRSCall.new( @call, @ssid, @repeated)
  end


  def <=>( other)
    @@logger.info( "<=>( other)")
    
    return self.to_s <=> other.to_s
  end


  def to_s
    @@logger.info( "to_s")

    buffer = String.new

    buffer << @call.strip

    if @ssid != 0
      buffer << "-" << @ssid.to_s
    end

    if @repeated
      buffer << "*"
    end

    return buffer
  end


  def repeated?
    @@logger.info( "repeated?")
    
    return @repeated
  end


  def decrease_ttl
    @@logger.info( "decrease_ttl")

    if @ssid > 0 
      @ssid -= 1 
    end

    return
  end


  def APRSCall.parse( value)
    @@logger.info( "parse( value)")

    callsign = value.clone

    if callsign.nil?
      return nil
    end

    call = APRSCall.new

    if callsign.index( '*') == (callsign.length - 1)
      call.repeated = true
      callsign.chop!
    end
    
    parts = callsign.split( '-')

    call.call = parts[0].upcase
    
    if parts.length == 2 
      call.ssid = parts[1].to_i
    end

    return call
  end

end
