#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'Logger'

require 'aprs4r/APRSCall'
require 'aprs4r/APRSMessage'


class TestSocket

  attr_reader :name, :type, :enable, :duplicatePeriod

  @@logger = Logger.get_logger( "TestSocket")


  def initialize( configuration)
    @@logger.info( "initialize( configuration)")

    @name = configuration.name
    @type = configuration.type
    @enable = configuration.enable
    @duplicatePeriod = configuration.duplicatePeriod

    if @enable
      initTestSocket()
    end

  end


  def initTestSocket
    @@logger.info( "initTestSocket")

    @file = File.new( "data/test-socket.1")

    return
  end


  def readAPRSMessage
    @@logger.info( "readAPRSMessage")

    sleep 60

    message = APRSMessage.new

    line = @file.gets.chomp
    while line =~ /^#/
      line = @socket.gets.chomp
    end

    parts = line.split( '|')

    message.source = APRSCall.parse( parts[0])
    message.destination = APRSCall.parse( parts[1])

    path = Array.new
    for i in 2...(parts.length-1)
      path << APRSCall.parse( parts[i])
    end
    message.path = path
    message.payload = parts[parts.length-1]

    return message
  end


  def writeAPRSMessage( message)
    @@logger.info( "writeAPRSMessage( message)")

    if message.nil?
      @@logger.warn( "message: NIL")
    end

    @@logger.debug( "message sent: #{message}")

    return
  end

end
      
    
