#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'Logger'

require 'aprs4r/APRSMessage'
require 'aprs4r/Plugin'
require 'aprs4r/MessagePluginConfiguration'


class MessagePlugin < Plugin

  @@logger = Logger.get_logger( "MessagePlugin")

  
  def initialize( configuration)
    @@logger.info( "initialize( configuration)")

    super( configuration)

    @timeout = configuration.timeout
    @rfDevice = configuration.rfDevice
    @isDevice = configuration.isDevice

    @stations = Hash.new
    
    return
  end

  
  def start 
    @@logger.info( "start")

    if ! @enable
      return
    end

    registerListener

    return
  end

  
  def registerListener
    @@logger.info( "registerListener")

    if @enable
      SocketManager.addListener( @rfDevice, self)
      SocketManager.addListener( @isDevice, self)
    end

    return
  end


  def unregisterListener
    @@logger.info( "registerListener")

    if @enable
      SocketManager.removeListener( @rfDevice, self)
      SocketManager.removeListener( @isDevice, self)
    end

    return
  end


  def receiveAPRSMessage( name, message)
    @@logger.info( "receiveAPRSMessage( name, message)")

    if message.nil? 
      return
    end

    if name == @rfDevice
      expireStations
      
      now = Time.now
      key = message.source.to_s
      @stations[key] = now
      
    elsif name == @isDevice && message.is_message?
      expireStations

      key = message.source.to_s
      if @stations.has_key( key)
        SocketManager.sendAPRSMessage( @rfDevice, message)
      end

    end

    return
  end


  def expireStations
    @@logger.info( "expireStations")

    now = Time.now

    # clean up station list 
    @stations.each{ |key, timestamp|
      if now - timestamp > @timeout
        @stations.delete( key)
      end
    }

    return
  end

end
