#!/usr/bin/ruby
#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#


module APRS4R
  APRS4RVersion = [0, 9, 6].join( '.')

  APRS4RCall = "AP4R0"
end


aprs4r_file = ARGV[0] || "/etc/aprs4r/default.yaml"
log4r_file = ENV['APRS4R_LOG4R'] || "/etc/aprs4r/default.log4r"
pid_file = ENV['APRS4R_PID'] || "/var/run/aprs4r.pid"

print "aprs4r_file: #{aprs4r_file}\n"
print "log4r_file: #{log4r_file}\n"
print "pid_file: #{pid_file}\n"

require 'Logger'
require 'Log4rConfigurator'

Log4rConfigurator::configure_from_yaml_file( log4r_file)

require 'aprs4r/APRS4RConfiguration'

require 'aprs4r/SocketManager'
require 'aprs4r/PluginManager'


# we want to see stacktraces from all threads
Thread.abort_on_exception = true

pid = File.new( pid_file, "w")
pid.puts( Process.pid)
pid.close

configuration = APRS4RConfiguration.loadConfiguration( aprs4r_file)

# init aprs4r core module
SocketManager.init( configuration)

sleep 2

# start generic plugin manager
PluginManager.init( configuration)
PluginManager.start()

sleep

