#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'Logger'

require 'serialport'

require 'aprs4r/APRSMessage'
require 'aprs4r/WeatherPlugin'
require 'aprs4r/WSconWeatherConfiguration'


class WSconWeatherPlugin < WeatherPlugin

  @@logger = Logger.get_logger( "WSconWeatherPlugin")

  
  def initialize( configuration)
    @@logger.info( "initialize( configuration)")

    super( configuration)

    @device = configuration.device
    @message = configuration.message

    return
  end

  def start
    @@logger.info( "start")

    if ! @enable
      return
    end

    # init serial port 
    @port = SerialPort.new( @device, 9600, 8, 1, SerialPort::NONE)
    @port.nonblock = true 
    @port.sync = true
      
    @port.flow_control = SerialPort::SOFT

    # run listener thread
    Thread.new{ runListener }

    # run init on upper class
    super

    return
  end


  def runListener
    @@logger.info( "runListener")

    while true 
      line = @port.gets

      if line 
        line.chomp!

        if @message 
          @message.payload = line
        end
      end
      
    end

    return
  end


  def createWeatherAPRSMessage
    @@logger.info( "createWeatherAPRSMessage")

    return @message.clone
  end



end
