#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'Logger'


class SocketThread

  @@logger = Logger.get_logger( "SocketThread");


  def initialize( socket)
    @@logger.info( "initialize( socket)")

    @socket = socket
    @name = socket.name
    @enable = socket.enable

    return
  end

  def run
    @@logger.info( "run")
    
    if !@enable 
      return
    end

    while true
      
      # wait for message
      message = @socket.readAPRSMessage

      @@logger.debug( "message recv on #{@name}: #{message}")

      # deliver message
      if !message.nil?
        SocketManager.receiveAPRSMessage( @name, message)
      end

    end

    return
  end

end
