#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'Logger'

require 'aprs4r/APRSMessage'
require 'aprs4r/Plugin'
require 'aprs4r/QueryPluginConfiguration'


class QueryPlugin < Plugin

  @@logger = Logger.get_logger( "QueryPlugin")

  
  def initialize( configuration)
    @@logger.info( "initialize( configuration)")

    super( configuration)

    @device = configuration.device
    @call = configuration.call
    
    return
  end
  
  
  def start 
    @@logger.info( "start")

    if ! @enable
      return
    end

    registerListener

    return
  end

  
  def registerListener
    @@logger.info( "registerListener")

    if @enable
      SocketManager.addListener( @device, self)
    end

    return
  end


  def unregisterListener
    @@logger.info( "registerListener")

    if @enable
      SocketManager.removeListener( @device, self)
    end

    return
  end


  def receiveAPRSMessage( name, message)
    @@logger.info( "receiveAPRSMessage( name, message)")

    if message.nil? 
      return
    end

    # handle general queries
    if message.is_query?
      
      payload = message.payload

      if payload.index( "?APRS?") == 0 
        handleAPRSQuery( message)
      elsif payload.index( "?IGATE?") == 0 
        handleIGATEQuery( message)
      elsif payload.index( "?WX?") == 0 
        handleWXQuery( message)
      end

    end

    # handle directed queries
    if message.is_message? && message.source.to_s == @call
      
    end

    return
  end


  def handleAPRSQuery( query)
    @@logger.info( "handleAPRSQuery")

    response = APRSMessage.new

    response.source = APRSCall.parse( @call)
    response.destination = APRSCall.parse( APRS4R::APRS4RCall)

    payload = ">PLEASE INSERT STATIONS POSITION"

    response.payload = payload

    SocketManager.sendAPRSMessage( @device, response)

    return
  end

  
  def handleIGATEQuery
    @@logger.info( "handleIGATEQuery")

    response = APRSMessage.new

    response.source = APRSCall.parse( @call)
    response.destination = APRSCall.parse( APRS4R::APRS4RCall)

    # TODO: use valid message counter, station counter
    payload = sprintf( "<IGATE,MSG_CNT=%i,LOC_CNT=%i", 34, 35)

    response.payload = payload

    SocketManager.sendAPRSMessage( @device, response)

    return
  end


  def handleWXQuery
    @@logger.info( "handleWXQuery")

    response = APRSMessage.new

    response.source = APRSCall.parse( @call)
    response.destination = APRSCall.parse( APRS4R::APRS4RCall)

    response.payload = ">PLEASE INSERT WEATHER MESSAGE"

    SocketManager.sendAPRSMessage( @device, response)

    return
  end

end
