#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'Logger'

require 'aprs4r/LogPluginConfiguration'
require 'aprs4r/Plugin'
require 'aprs4r/SocketManager'


class LogPlugin < Plugin

  @@logger = Logger.get_logger( "LogPlugin")


  def initialize( configuration)
    @@logger.info( "initialize( configuration)")

    super( configuration)

    @device = configuration.device
    @file = File.new( configuration.file, "w+")

    return
  end


  def registerListener
    @@logger.info( "registerListener")

    if @enable
      SocketManager.addListener( @device, self)
    end

    return
  end


  def unregisterListener
    @@logger.info( "registerListener")

    if @enable
      SocketManager.removeListener( @device, self)
    end

    return
  end


  def start
    @@logger.info( "start")

    if ! @enable 
      return
    end

    registerListener

    return
  end

  
  def receiveAPRSMessage( name, message)
    @@logger.info( "receiveAPRSMessage( name, message)")

    if name.nil? || message.nil? 
      @@logger.warn( "bogus message received")
      return
    end

    now = Time.now
    timestamp = sprintf( "%4.4i-%2.2i-%2.2i-%2.2i-%2.2i-%2.2i", now.year, now.month, now.day, now.hour, now.min, now.sec)

    path = String.new

    if message.path
      message.path.each{ |entry|
        path += entry + "/"
      }
    end

    line = sprintf( "%s|%s|%s|%s|%s", timestamp, message.source, message.destination, path, message.payload)

    @file.puts( line)
    @file.flush

    return
  end

end
