#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'socket'

require 'Logger'

require 'aprs4r/ISServerConfiguration'
require 'aprs4r/ISServerSocket'

require 'aprs4r/Plugin'


class ISServerPlugin < Plugin

  @@logger = Logger.get_logger( "ISServerPlugin")

  
  def initialize( configuration)
    @@logger.info( "initialize( configuration)")

    super( configuration)

    @port = configuration.port
    @device = configuration.device

    @serverSocket = ISServerSocket.new( @port)
    @clientSockets = Array.new

    return
  end

  
  def start 
    @@logger.info( "start")

    if ! @enable
      return
    end

    Thread.new { runServerThread } 

    registerListener

    return
  end

  
  def registerListener
    @@logger.info( "registerListener")

    if @enable
      SocketManager.addListener( @device, self)
    end

    return
  end


  def unregisterListener
    @@logger.info( "registerListener")

    if @enable
      SocketManager.removeListener( @device, self)
    end

    return
  end


  def runServerThread
    @@logger.info( "run")

    while true 
      clientSocket = @serverSocket.accept

      @@logger.warn( "clientSocket: #{clientSocket}")

      if clientSocket 
        Thread.new { runClientThread( clientSocket) } 
        @clientSockets << clientSocket
      end

    end
  end


  def runClientThread( clientSocket)
    @@logger.info( "runClientThead( clientSocket)")

    run = true 

    while run
      begin
        message = clientSocket.readAPRSMessage
        @@logger.warn( "recv local is message: #{message}")
        
        SocketManager.sendAPRSMessage( @device, message)

      rescue Exception => ex
        @@logger.warn( "runClientThread::ex: " + ex)
        @clientSockets.delete( clientSocket)
        run = false
      end
    end

    return
  end

  
  def receiveAPRSMessage( name, message)
    @@logger.info( "receiveAPRSMessage( name, message)")

    if message.nil? || name != @device 
      return
    end

    @clientSockets.each{ |clientSocket|
      
      begin
        @@logger.warn( "send local is message: #{message}")
        clientSocket.writeAPRSMessage( message)
      rescue Exception => ex
        @@logger.warn( "receiveAPRSMessage::ex: " + ex)
        @clientSockets.delete( clientSocket)
      end

    }
    
    return
  end

end
