#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'Logger'

require 'aprs4r/APRSCall'
require 'aprs4r/APRSMessage'


class DigipeaterHandler

  @@logger = Logger.get_logger( "DigipeaterHandler")

  
  def initialize( configuration)
    @@logger.info( "initialize( configuration)")

    @name = configuration.name
    @enable = configuration.enable
    @device = configuration.device
    @call = configuration.call

#    @optimizePath = configuration.optimizePath
#    @cleanupPath = configuration.cleanupPath

    @enableRelay = configuration.enableRelay

    @relayAliases = Array.new
    aliases = configuration.relayAliases
    aliases.each{ |entry|
      call = APRSCall.parse( entry)
      @relayAliases << call 
    }

    @enableWide = configuration.enableWide

    return
  end


  def registerListener
    @@logger.info( "registerListener")

    if @enable
      SocketManager.addListener( @device, self)
    end

    return
  end


  def unregisterListener
    @@logger.info( "registerListener")

    if @enable
      SocketManager.removeListener( @device, self)
    end

    return
  end


  def receiveAPRSMessage( name, message)
    @@logger.info( "receiveAPRSMessage( name, message)")

    if message.nil?
      @@logger.warn( "message: nil\n")
      return
    end

    @@logger.debug( "message: #{message}")

    if !@enableRelay && @enableWide
      @@logger.warn( "no digi mode selected")
      return
    end

#    if @optimizePath
#      optimizePath( message)
#    end

#    if @cleanupPath
#      cleanupPath( message)
#    end

    path = message.path
    repeat = false

    # no path, no digipeating
    if message.path.nil?
      @@logger.debug( "before return")
      return
    end

    # search for keyword
    found = false
    mode = nil
    index = 0

    for i in 0...path.length
      @@logger.debug( "path[i]: #{path[i]}")
      entry = APRSCall.parse( path[i])
      @@logger.debug( "path[i]: #{path[i]}")
      @@logger.debug( "checking entry: #{entry}")

      next if entry.repeated?

      if @enableRelay && @relayAliases.include?( entry)
        # check for relay keyword

        mode = APRSMessage.APRS_PATH_RELAY
        found = true 
        index = i
        break
      elsif @enableWide && entry.call.include?( APRSMessage.APRS_PATH_WIDE) # FIXME
        # check for wide keyword
      
        mode = APRSMessage.APRS_PATH_WIDE
        found = true
        index = i
        break
      elsif @enableWide && entry.call.include?( APRSMessage.APRS_PATH_TRACE) # FIXME
        # check for trace keyword

        mode = APRSMessage.APRS_PATH_TRACE
        found = true
        index = i
        break
      end
          
    end

    @@logger.debug( "mode: #{mode}")
    @@logger.debug( "found: #{found}")

    # no keyword found, no digipeater handling
    if !found 
      @@logger.debug( "!found -> return")
      return
    end

    # relay check
    if mode == APRSMessage.APRS_PATH_RELAY
      relayCall = APRSCall.parse( @call)
      relayCall.repeated = true 
      path[index] = relayCall.to_s
      repeat = true
    end

    # wide check
    if mode == APRSMessage.APRS_PATH_WIDE
      wideCall = APRSCall.parse( path[index])
      @@logger.debug( "wideCall: #{wideCall}")

      # simple wide
      if wideCall.call == APRSMessage.APRS_PATH_WIDE
        repeat = true
      else # extended wide (WIDEm-n)
        # TODO check WIDEm-n with n > m 
        if wideCall.ssid > 0 
          wideCall.decrease_ttl
          repeat = true
        end
      end

      if wideCall.ssid == 0 
        wideCall.repeated = true
      end

      path[index] = wideCall.to_s
    end

    # trace check
    if mode == APRSMessage.APRS_PATH_TRACE
      traceCall = APRSCall.parse( path[index])

      # simple trace
      if traceCall.call == APRSMessage.APRS_PATH_TRACE
        traceCall = APRSCall.parse( @call)
        traceCall.repeated = true
        path[index] = traceCall.to_s
        repeat = true
      else # extended trace (TRACEm-n)
        # TODO check WIDEm-n with n > m 
        if traceCall.ssid > 0
          digiCall = APRSCall.parse( @call)
          digiCall.repeated = true
          traceCall.decrease_ttl
          if traceCall.ssid == 0 
            traceCall.repeated = true
          end
          path[i] = traceCall.to_s
          path.insert( index, digiCall.to_s)
          repeat = true
        end
      end
    end


    # repeat message on same interface
    if repeat
      @@logger.debug( "send message: #{message}")
      SocketManager.sendAPRSMessage( @device, message)
    end

    return
  end


  def optimizePath( message)
    @@logger.debug( "optimizePath( message)")

    if message.nil?
      @@logger.warn( "message: NIL")
    end

    path = message.path

    if path.nil? 
      return
    end

    # wide path cleanup
    foundWide = false
    wideCounter = 0
    
    # looking for WIDEs
    wideCounter = 0 
    
    for i in 0...path.length
      entry = path[index]
      
      if !entry.repeated? && entry.call == "WIDE"
        wideCounter += 1
        foundWide = true
        
      end
    end
    
    replacedWide = false
    if wideCounter > 1
      
      path.each{ |entry|
        
      }
    end

    return
  end


  def cleanupPath( message)
    @@logger.info( "cleanupPath( message)")

    if message.nil? || message.path.nil?
      @@logger.warn( "message || message.path: NIL")
    end

    path = message.path

    # relay path cleanup
    foundRelay = false
      
    path.each{ |entry|
      if !entry.repeated? && entry.call == "RELAY"
        if foundRelay
          path.delete( entry)
        else 
          foundRelay = true
        end
      end
    }
    
    path.each{ |entry|
      # remove WIDE4-4, WIDE5-5, WIDE6-6
      if entry == APRSCall.new( "WIDE4", 4) || entry == APRSCall.new( "WIDE5", 5) || entry == APRSCall.new( "WIDE6", 6)
        path.delete( entry)
      end
    }

    return
  end

end
