#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'yaml'

require 'Logger'

require 'aprs4r/APRSCall'
require 'aprs4r/APRSMessage'
require 'aprs4r/SocketConfiguration'
require 'aprs4r/ISSocketConfiguration'
require 'aprs4r/AX25SocketConfiguration'
require 'aprs4r/RawSocketConfiguration'
require 'aprs4r/TestSocketConfiguration'

require 'aprs4r/BeaconConfiguration'
require 'aprs4r/GatewayConfiguration'
require 'aprs4r/DigipeaterConfiguration'

require 'aprs4r/PluginConfiguration'
require 'aprs4r/LCD4LinuxPluginConfiguration'
require 'aprs4r/XMLDataPluginConfiguration'
require 'aprs4r/QueryPluginConfiguration'
require 'aprs4r/MessagePluginConfiguration'
require 'aprs4r/ISServerConfiguration'
require 'aprs4r/WeatherConfiguration'
require 'aprs4r/WMRWeatherConfiguration'


class APRS4RConfiguration

  attr_reader :devices, :beacons, :gateways, :digipeaters, :plugins
  attr_writer :devices, :beacons, :gateways, :digipeaters, :plugins

  @@logger = Logger.get_logger( "APRS4RConfiguration")


  def initialize
    @@logger.info( "initialize()")

    @devices = Hash.new

    @beacons = Hash.new
    @gateways = Hash.new
    @digipeaters = Hash.new

    return
  end


  def APRS4RConfiguration.getConfiguration()
    @@logger.info( "getConfiguration()")

    return @@configuration 
  end


  def APRS4RConfiguration.setConfiguration( configuration)
    @@logger.info( "setConfiguration( configuration)")

    @@configuration = configuration

    return
  end


  def APRS4RConfiguration.loadConfiguration( name) 
    @@logger.info( "loadConfiguration( name)")

    return YAML.load_file( name)
  end


  def APRS4RConfiguration.saveConfiguration( name, configuration)
    @@logger.info( "saveConfiguration( name, configuration)")

    file = File.new( name, "w") 

    YAML.dump( configuration, file)

    return
  end


  def to_yaml_properties
    %w{@devices @beacons @gateways @digipeaters @plugins}
  end

end
