#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'Logger'

require 'aprs4r/APRSMessage'
require 'aprs4r/Plugin'
require 'aprs4r/LCD4LinuxPluginConfiguration'

class LCD4LinuxPlugin < Plugin

  @@logger = Logger.get_logger( "LCD4LinuxPlugin")

  
  def initialize( configuration)
    @@logger.info( "initialize( configuration)")

    super( configuration)

    @file = configuration.file
    
    return
  end

  
  def start 
    @@logger.info( "start")

    if ! @enable
      return
    end

    Thread.new { run() } 

    return
  end

  
  def run 
    @@logger.info( "run")

    uptime = 0
    minute = 60
    hour = 60 * minute 
    day = 24 * hour

    while true 

      rf0recvCount = SocketManager.recvCount( "rf0")
      rf0sendCount = SocketManager.sendCount( "rf0")
      is0recvCount = SocketManager.recvCount( "is0")
      is0sendCount = SocketManager.sendCount( "is0")

      line1 = sprintf( "APRS4R-%5s", APRS4R::APRS4RVersion)

      if uptime > day
        days = uptime / day
        hours = (uptime % day) / hour

        line1 = sprintf( "APRS4R-%5s %03id%02ih", APRS4R::APRS4RVersion, days, hours)
      else
        hours = uptime / hour 
        minutes = (uptime % hour) / minute
       
        line1 = sprintf( "APRS4R-%5s %03ih%02im", APRS4R::APRS4RVersion, hours, minutes)
      end

      line2 = sprintf( "rf0 in %4.4s out %4.4s", rf0recvCount, rf0sendCount)
      line3 = sprintf( "is0 in %4.4s out %4.4s", is0recvCount, is0sendCount)
      line4 = ""

      message = SocketManager.lastMessage

      if message
        line4 = message.to_s
      end

      file = File.new( @file, "w")
      file.puts( line1)
      file.puts( line2)
      file.puts( line3)
      file.puts( line4)
      file.close

      uptime += 30
      sleep 30

    end

  end
end
