#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'aprs4r/APRSCall'
require 'aprs4r/ConfigurationAttribute'

class BeaconConfiguration

  attr_reader :name, :enable, :device, :period, :offset, :message
  attr_writer :name, :enable, :device, :period, :offset, :message


  def to_yaml_properties
    %w{ @name @enable @device @period @offset @message}
  end

  
  def attributes 

    print "attributes\n"

    attributes = Array.new
    
    attributes << ConfigurationAttribute.new( "name", 1, "text", "scalar", "Name", 10)
    attributes << ConfigurationAttribute.new( "enable", 2, "radio", "scalar", "Aktivieren", 0)

    attributes << ConfigurationAttribute.new( "device", 3, "text", "scalar", "Geraet", 10)
    attributes << ConfigurationAttribute.new( "period", 4, "text", "scalar", "Periode", 5)
    attributes << ConfigurationAttribute.new( "offset", 5, "text", "scalar", "Offset", 5)

    return attributes
  end
    
  

end
