#!/usr/bin/ruby
#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'include'

require 'aprs4r/APRSMessage'

require 'aprs4r/RawSocket'
require 'aprs4r/RawSocketConfiguration'


configuration = RawSocketConfiguration.new
configuration.name = "rf0"
configuration.type = "RawSocket"
configuration.enable = true 
configuration.device = "/dev/ttyUSB0"

socket = RawSocket.new( configuration)

message = socket.readAPRSMessage

if message != nil 
  print "message: #{message.to_s}\n"
end
