#!/usr/bin/ruby
#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#


module APRS4R
  APRS4RVersion = [0, 9, 2].join( '.')

  APRS4RCall = "AP4R0"
end



path = ENV['APRS4R_ETC'] || "/etc/aprs4r" 
log4r = ENV['APRS4R_LOG4R'] || "log4r.yaml"
file = ARGV[0] || "#{path}/default.yaml"

print "path: #{path}\n"
print "log4r: #{log4r}\n"
print "file: #{file}\n"

require 'Logger'
require 'Log4rConfigurator'

Log4rConfigurator::configure_from_yaml_file( "#{path}/#{log4r}")

require 'aprs4r/APRS4RConfiguration'

require 'aprs4r/SocketManager'
require 'aprs4r/BeaconManager'
require 'aprs4r/DigipeaterManager'
require 'aprs4r/GatewayManager'
require 'aprs4r/PluginManager'


# we want to see stacktraces from all threads
Thread.abort_on_exception = true

configuration = APRS4RConfiguration.loadConfiguration( "#{file}")

# init aprs4r core module
SocketManager.init( configuration)

sleep 2

# start beacon block
BeaconManager.init( configuration)
BeaconManager.start()

# start gateway block
GatewayManager.init( configuration)
GatewayManager.start()

# start digipeater block
DigipeaterManager.init( configuration)
DigipeaterManager.start()

# start generic plugin block
PluginManager.init( configuration)
PluginManager.start()

sleep

