#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'io/nonblock'

require 'Logger'

require 'aprs4r/APRSCall'


class RawSocket

  attr_reader :name, :type, :enable

  @@logger = Logger::get_logger( "RawSocket")


  def initialize( configuration)
    @@logger.info( "initialize( configuration)")

    @name = configuration.name
    @type = configuration.type
    @enable = configuration.enable
    @device = configuration.device

    initRawSocket()

    return
  end

  def initRawSocket()
    @@logger.info( "initRawSocket")

    if ! @enable
      return
    end

    @socket = File.new( @device)
    @socket.nonblock = true

    return
  end


  def readAPRSMessage
    @@logger.info( "readAPRSMessage")

    line = @socket.gets.chomp
    @@logger.debug( "readAPRSMessage::line: -#{line}-\n")
    
    headerIndex = line.index( ':')
    
    if headerIndex.nil?
    	return nil
    end
    
    message = APRSMessage.new

    # header
    header = line[0...headerIndex]

    sourceIndex = header.index( '>')
      
    if sourceIndex.nil?
      return nil
    end
        
    message.source = APRSCall.parse( header[0...sourceIndex])

    path = header[sourceIndex+1...header.length].split( ',')
    message.destination = APRSMessage.parse( path[0])
    path.delete_at( 0)

    path.each{ |entry|
      call = APRSCall.parse( entry)
      message.path << call
    }

    # body
    body = line[headerIndex+1...line.length]
    message.payload = body
 
    return message
  end

end
