#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'Logger'

require 'aprs4r/LCD4LinuxPlugin'
require 'aprs4r/XMLDataPlugin'


class PluginManager

  @@configuration = nil

  @@logger = Logger.get_logger( "PluginManager")


  def PluginManager.init( configuration)
    @@logger.info( "init( configuration)")
    
    @@configuration = configuration.plugins

    return
  end


  def PluginManager.start
    @@logger.info( "start()")

    if @@configuration.nil?
      return 
    end
    
    @@configuration.each { |name, configuration| 

      name = configuration.name
      type = configuration.type
      enable = configuration.enable

      if enable 
        @@logger.debug( "name: #{name}\n")
        @@logger.debug( "type: #{type}\n")
        @@logger.debug( "configuration: #{configuration}\n")

        # TODO: add dynamic plugin class loading using type attribute

        plugin = nil

        if type == "LCD4LinuxPlugin"
          plugin = LCD4LinuxPlugin.new( configuration)
        elsif type == "XMLDataPlugin"
          plugin = XMLDataPlugin.new( configuration)
        end

        if plugin
          plugin.start()
        end

      end
    }

    return
  end

end
