#!/usr/bin/ruby
#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'include'

require 'aprs4r/APRS4RConfiguration'

require 'aprs4r/AX25SocketConfiguration'
require 'aprs4r/ISSocketConfiguration'
require 'aprs4r/RawSocketConfiguration'

require 'aprs4r/BeaconConfiguration'
require 'aprs4r/GatewayConfiguration'
require 'aprs4r/DigipeaterConfiguration'

require 'aprs4r/APRSMessage'


configuration = APRS4RConfiguration.new

# devices
rf1 = AX25SocketConfiguration.new
rf1.name = "rf1"
rf1.type = "AX25Socket"
rf1.enable = true
rf1.device = "/dev/tts/1"
rf1.mode = "kiss"
rf1.call = "DG4LO-10"

configuration.devices[rf1.name]=rf1

is0 = ISSocketConfiguration.new
is0.name = "is0"
is0.type = "ISAPRSSocket"
is0.host = "third.aprs.net" 
is0.port = 10155
is0.username = "DG4LO-10"
is0.password = "abcdef"
is0.filter = "# filter m/50"

configuration.devices[is0.name]=is0


# beacons
is0Beacon = BeaconConfiguration.new
is0Beacon.name = "is0Beacon"
is0Beacon.enable = true
is0Beacon.device = "is0"
is0Beacon.period = 30
message = APRSMessage.new
message.source = "DG4LO-10"
message.destination = "APWRT"
message.path = Array.new
message.payload = "=4900.05NI00823.29E&PHG3270/*  IGate  Karlsruhe"
is0Beacon.message = message

configuration.beacons[is0Beacon.name]=is0Beacon

# gateways
rf2isGateway = GatewayConfiguration.new
rf2isGateway.name = "rf2isGateway"
rf2isGateway.enable = true 
rf2isGateway.inDevice = "rf0"
rf2isGateway.outDevice = "is0"
rf2isGateway.filter = ";"

configuration.gateways[rf2isGateway.name]=rf2isGateway

# digipeaters
rfDigipeater = DigipeaterConfiguration.new
rfDigipeater.name = "rfDigipeater"
rfDigipeater.enable = true
rfDigipeater.device = "rf0"
rfDigipeater.enableRelay = true
rfDigipeater.relayAliases = ["RELAY", "DG4LO-10"]
rfDigipeater.enableWide = false

configuration.digipeaters[rfDigipeater.name]=rfDigipeater

APRS4RConfiguration.saveConfiguration( "write-test.yaml", configuration)
