#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'Logger'

require 'aprs4r/BeaconThread'


class BeaconManager

  @@configuration = nil
  @@threads = Array.new

  @@logger = Logger.get_logger( "BeaconManager")


  def BeaconManager.init( configuration)
    @@logger.info( "init( configuration)")
    
    @@configuration = configuration.beacons

    return
  end


  def BeaconManager.start
    @@logger.info( "start()")
    
    @@configuration.each { |name, configuration| 

      if configuration.enable 
        @@logger.debug( "name: #{name}\n")
        @@logger.debug( "configuration: #{configuration}\n")

        @@threads << Thread.new { 
          thread = BeaconThread.new( configuration)
          thread.run
        }

      end
    }

    return
  end

end
