#
#  APRS4R - a ruby based aprs gateway/digipeater
#  Copyright (C) 2006 by Michael Conrad <do5mc@friggleware.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
#

require 'Logger'

require 'aprs4r/APRSCall'


class APRSMessage

  @@APRS_PATH_RELAY = "RELAY"
  @@APRS_PATH_WIDE  = "WIDE"
  @@APRS_PATH_TRACE = "TRACE"

  @@APRS_DATA_IDENTIFIER_REPORT = "!/=@"
  @@APRS_DATA_IDENTIFIER_MESSAGE = ":"
  @@APRS_DATA_IDENTIFIER_QUERY = "?"

  attr_reader :source, :destination, :path, :payload
  attr_writer :source, :destination, :path, :payload

  @@logger = Logger.get_logger( 'APRSMessage')


  def initalize( source = APRSCall.new, destination = APRSCall.new, path = Array.new, payload = nil)
    @@logger.info( "initialize( source, destination, path, payload)")
    
    @source = source
    @destination = destination
    @path = path
    @payload = payload
    
    return
  end


  def clone
    @@logger.info( "clone")
    
    message = APRSMessage.new

    message.source = @source.clone
    message.destination = @destination.clone

    path = Array.new
    @path.each{ |entry| path << entry.clone} if @path
    message.path = path

    message.payload = String.new( @payload)

    return message
  end


  def duplicate_key
    @@logger.info( "duplicate_key")
    
    key = String.new

    key << source.to_s << ">" << destination.to_s
    key << ":" << payload

    return key
  end


  def to_yaml_properties
    %w{@source @destination @path @payload}
  end

  def is_report?
    return @@APRS_DATA_IDENTIFIER_REPORT.include?( payload[0])
  end

  def is_message?
    return @@APRS_DATA_IDENTIFIER_MESSAGE.include?( payload[0])
  end

  def is_query?
    return @@APRS_DATA_IDENTIFIER_QUERY.include?( payload[0])
  end

  def is_type?( type)
    
    if type.nil?
      return false
    end

    return type.include( payload[0])
  end


  def to_s
    buffer = String.new

    buffer << "APRSMessage: "
    buffer << @source.to_s << " -> "
    buffer << @destination.to_s << " via "
    
    path = String.new
    for i in 0...@path.length

      if i != 0 
        path = path + ", "
      end

      path = path + @path[i].to_s
    end
    path = path

    buffer << "[" << path << "]: "
    buffer << "(" << @payload << ")"

    return buffer.to_s
  end

  
  def APRSMessage.APRS_PATH_RELAY
    return @@APRS_PATH_RELAY
  end

  def APRSMessage.APRS_PATH_WIDE
    return @@APRS_PATH_WIDE
  end

  def APRSMessage.APRS_PATH_TRACE
    return @@APRS_PATH_TRACE
  end

end
